*************************************************************************
BY: Jim Sullivan
 
CHAGNE: 10/18/2011: ADDED 2010 
CHAGNE: 11/2/2010: ADDED 2009 

CHAGNE: 12/19/2009: ADDED 2006-2008 

CHAGNE: 3/17/2008: ADDED 2005 AND NOW KEEP OBS FROM 04:5 AND 05:5

*************************************************************************;


LIBNAME mydat '~/jim/data';

filename IHB8081 pipe 'gunzip -c ~/jim/data/Health/08423-0039-Data.txt.gz';
filename IHB88 pipe 'gunzip -c ~/jim/data/Health/09842-0039-Data.txt.gz';
filename IHB89 pipe 'gunzip -c ~/jim/data/Health/09841-0039-Data.txt.gz';
filename IHB90 pipe 'gunzip -c ~/jim/data/Health/09817-0039-Data.txt.gz';
filename IHB91 pipe 'gunzip -c ~/jim/data/Health/06262-0043-Data.txt.gz';
filename IHB92 pipe 'gunzip -c ~/jim/data/Health/06440-0042-Data.txt.gz';
filename IHB93 pipe 'gunzip -c ~/jim/data/Health/06543-0040-Data.txt.gz';
filename IHB94 pipe 'gunzip -c ~/jim/data/Health/06710-0048-Data.txt.gz';
filename IHB95 pipe 'gunzip -c ~/jim/data/Health/02264-0052-Data.txt.gz';
filename IHB96 pipe 'gunzip -c ~/jim/data/Health/02794-0052-Data.txt.gz';
filename IHB97 pipe 'gunzip -c ~/jim/data/Health/02838-0052-Data.txt.gz';
filename IHB98 pipe 'gunzip -c ~/jim/data/Health/02971-0052-Data.txt.gz';
filename IHB99 pipe 'gunzip -c ~/jim/data/Health/03228-0052-Data.txt.gz';
filename IHB00 pipe 'gunzip -c ~/jim/data/Health/03396-0052-Data.txt.gz';
filename IHB01 pipe 'gunzip -c ~/jim/data/Health/03674-0053-Data.txt.gz';
filename IHB02 pipe 'gunzip -c ~/jim/data/Health/03949-0052-Data.txt.gz';
filename IHB03 pipe 'gunzip -c ~/jim/data/Health/ihb03.txt.gz';
filename IHB04 pipe 'gunzip -c ~/jim/data/Health/ihb04.txt.gz';
filename IHB05 pipe 'gunzip -c ~/jim/data/Health/ihb05.txt.gz';
filename IHB06 pipe 'gunzip -c ~/jim/data/Health/ihb06.txt.gz';
filename IHB07 pipe 'gunzip -c ~/jim/data/Health/ihb07.txt.gz';
filename IHB08 pipe 'gunzip -c ~/jim/data/Health/ihb08.txt.gz';
filename IHB09 pipe 'gunzip -c ~/jim/data/Health/ihb09.txt.gz';
filename IHB10 pipe 'gunzip -c ~/jim/data/Health/ihb10.txt.gz';


%macro read_ihb(yr,dir);

options obs=max mprint;
data priv&yr;
infile &dir missover lrecl=2000;

if &yr=80 then do;
input qyear 1-3 NEWID 4-11 polnum 19-20 hhistatb 22 HHIGROUP 26 HHIPRMPD 30 period 41 QHI3MCX 81-88 HHITYPYB 24 hhiplan 45;
* delete discontinued policies;
IF hhistatb=1 THEN DELETE;
newid=9000000+newid;
end;

if 88<=&yr<=91 then do;
input qyear 1-3 NEWID 4-11 polnum 19-20 hhistatb 22 HHIGROUP 32 HHIPRMPD 36 period 40 QHI3MCX 42-49 HHITYPYB 24 HHICOVQ 29-30;
* delete obs for following year;
IF FLOOR(qyear/10) NE &yr THEN DELETE;
* delete discontinued policies;
IF hhistatb=1 THEN DELETE;
end;

if 92<=&yr<=94 then do;
input qyear 1-3 NEWID 4-11 polnum 19-20 hhistatb 22 HHIGROUP 29 HHIPRMPD 33 period 37 QHI3MCX 39-46 HHITYPYB  24 HHICOVQ 26-27;
* delete obs for following year;
IF FLOOR(qyear/10) NE &yr THEN DELETE;
* delete discontinued policies;
IF hhistatb=1 THEN DELETE;
end;

if &yr=95 then do;
input qyear 1-3 NEWID 4-11 polnum 19-20 hhistatb 22 HHIGROUP 29 HHIPRMPD 33 period 37 QHI3MCX 39-46 HHITYPYB  24 HHICOVQ 26-27  
HHICODE 50 HHIPOS 52;
* delete discontinued policies;
IF hhistatb=1 THEN DELETE;
end;

if 96<=&yr<=110 then do;
input qyear 1-5 NEWID 6-13 polnum 21-22 hhistatb 24 HHIGROUP 29 HHIPRMPD 31 period 35 QHI3MCX 37-44 HHICOVQ 26-27 HHICODE 48 
HHIPOS 50;
* DELETE OBS FOR FOLLOWING YEAR, BUT KEEP FOR 2004, B/C THAT'S A CHANGE-IN-SAMPLE YEAR, 
  AND 2010 B/C IT'S THE FINAL YEAR OF DATA; 
IF FLOOR(qyear/10) NE 1900+&yr AND &yr LE 103 THEN DELETE;
IF FLOOR(qyear/10) NE 1900+&yr AND &yr IN(105,106,107,108,109) THEN DELETE;

* delete discontinued policies;
IF hhistatb=1 THEN DELETE;
end;

count=1; 
RUN; 

PROC MEANS;
RUN; 

PROC SORT;
   BY newid ;

DATA priv&yr;
   SET priv&yr; 
   BY newid; 

* Premium is not reported if employer or union pays all of the premium;
IF  HHIPRMPD IN(3,4) AND QHI3MCX=. THEN QHI3MCX=0;

* 99 is missing for this var;
IF HHICOVQ=99 THEN HHICOVQ=.;

IF qyear GT 814 AND HHICOVQ=1 THEN ind_plan=1;
   ELSE IF qyear GT 814 AND HHICOVQ GT 1 THEN ind_plan=0;
   ELSE IF 801 LE qyear LE 814 AND hhiplan=1 THEN ind_plan=1;
   ELSE IF 801 LE qyear LE 814 AND hhiplan GT 1 THEN ind_plan=0;

IF 801 LE qyear LE 814 AND hhiplan GT 1 THEN fam_plan=1;
   ELSE IF 801 LE qyear LE 814 AND hhiplan=1 THEN fam_plan=0;

RETAIN counter; 
IF FIRST.newid THEN DO; 
counter=0;
END;   
counter=counter+1;
 
ARRAY num_cv(1:12);
ARRAY prem(1:12);
ARRAY prem_pd(1:12);
 
   do t=1 to 12; 
        IF counter=t THEN num_cv(t)= HHICOVQ;
        ELSE num_cv(t)= 0;
    
        IF counter=t THEN prem(t)= QHI3MCX; 
        ELSE prem(t)= 0;
 
        IF counter=t THEN prem_pd(t)= HHIPRMPD;
        ELSE prem_pd(t)= 0; 
 
   END; 
 
RUN;

PROC MEANS SUM NOPRINT;
   BY newid;
   ID qyear;
   VAR count HHICOVQ QHI3MCX HHIPRMPD num_cv1-num_cv12 prem1-prem12 prem_pd1-prem_pd12 ind_plan fam_plan;
   OUTPUT OUT=temp1 SUM=num_pol num_cov premium howpdsum num_cv1-num_cv12 
			prem1-prem12 prem_pd1-prem_pd12 num_ind_plan num_fam_plan;
RUN;

DATA cu_priv&yr;
   SET temp1(KEEP=newid qyear num_pol num_cov premium howpdsum num_cv1-num_cv12 
			prem1-prem12 prem_pd1-prem_pd12 num_ind_plan num_fam_plan);

RUN;
PROC MEANS;
RUN;
%mend read_ihb;


%read_ihb(80,IHB8081);
%read_ihb(88,IHB88);
%read_ihb(89,IHB89);
%read_ihb(90,IHB90);
%read_ihb(91,IHB91);
%read_ihb(92,IHB92);
%read_ihb(93,IHB93);
%read_ihb(94,IHB94);
%read_ihb(95,IHB95);
%read_ihb(96,IHB96);
%read_ihb(97,IHB97);
%read_ihb(98,IHB98);
%read_ihb(99,IHB99);
%read_ihb(100,IHB00);
%read_ihb(101,IHB01);
%read_ihb(102,IHB02);
%read_ihb(103,IHB03);
%read_ihb(104,IHB04);
%read_ihb(105,IHB05);
%read_ihb(106,IHB06);
%read_ihb(107,IHB07);
%read_ihb(108,IHB08);
%read_ihb(109,IHB09);
%read_ihb(110,IHB10);


**********************************************************************
MAKE ADJUSTMENT FOR FACT THAT SOME OBS ARE IN BOTH 95:5 AND 96:1
THIS DELETES CU'S IN 1995 THAT ARE ALSO IN 1996
**********************************************************************;
DATA cu_priv95; 
MERGE cu_priv95(IN=in1) cu_priv96(IN=in2); 
BY newid; 
if in2 THEN dat2=1; 
else dat2=0; 
IF in1; 
IF dat2=1 THEN DELETE; 
RUN; 
**********************************************************************
MAKE ADJUSTMENT FOR FACT THAT SOME OBS ARE IN BOTH 04:5 AND 05:1
THIS DELETES CU'S IN 2004 THAT ARE ALSO IN 2005
**********************************************************************;
DATA cu_priv104; 
MERGE cu_priv104(IN=in1) cu_priv105(IN=in2); 
BY newid; 
if in2 THEN dat2=1; 
else dat2=0; 
IF in1; 
IF dat2=1 THEN DELETE; 
RUN; 


DATA all_priv;
SET cu_priv80 cu_priv88 cu_priv89 cu_priv90 cu_priv91
    cu_priv92 cu_priv93 cu_priv94 cu_priv95 
    cu_priv96 cu_priv97 cu_priv98 cu_priv99 
    cu_priv100 cu_priv101 cu_priv102 cu_priv103 cu_priv104
    cu_priv105 cu_priv106 cu_priv107 cu_priv108 cu_priv109 cu_priv110;

* THIS WILL MATCH SRV_YEAR FROM FAMILY FILES EVEN IN QUARTER 5
  OF A SURVEY YEAR B/C QYEAR HERE IS TAKEN FROM THE DATA, NOT 
  GENERATED BY ME;
IF 801 LE qyear LE 961 THEN srv_year=floor(qyear/10);
   ELSE IF qyear GE 19961 THEN srv_year=floor(qyear/10)-1900;

RUN;
PROC SORT;
BY newid srv_year;
RUN;


*******************************************************************************
MEDICAID / MEDICARE
*******************************************************************************;
filename IHC8081 pipe 'gunzip -c ~/jim/data/Health/08423-0040-Data.txt.gz';
filename IHC88 pipe 'gunzip -c ~/jim/data/Health/09842-0040-Data.txt.gz';
filename IHC89 pipe 'gunzip -c ~/jim/data/Health/09841-0040-Data.txt.gz';
filename IHC90 pipe 'gunzip -c ~/jim/data/Health/09817-0040-Data.txt.gz';
filename IHC91 pipe 'gunzip -c ~/jim/data/Health/06262-0044-Data.txt.gz';
filename IHC92 pipe 'gunzip -c ~/jim/data/Health/06440-0043-Data.txt.gz';
filename IHC93 pipe 'gunzip -c ~/jim/data/Health/06543-0041-Data.txt.gz';
filename IHC94 pipe 'gunzip -c ~/jim/data/Health/06710-0049-Data.txt.gz';
filename IHC95 pipe 'gunzip -c ~/jim/data/Health/02264-0053-Data.txt.gz';
filename IHC96 pipe 'gunzip -c ~/jim/data/Health/02794-0053-Data.txt.gz';
filename IHC97 pipe 'gunzip -c ~/jim/data/Health/02838-0053-Data.txt.gz';
filename IHC98 pipe 'gunzip -c ~/jim/data/Health/02971-0053-Data.txt.gz';
filename IHC99 pipe 'gunzip -c ~/jim/data/Health/03228-0053-Data.txt.gz';
filename IHC00 pipe 'gunzip -c ~/jim/data/Health/03396-0053-Data.txt.gz';
filename IHC01 pipe 'gunzip -c ~/jim/data/Health/03674-0054-Data.txt.gz';
filename IHC02 pipe 'gunzip -c ~/jim/data/Health/03949-0053-Data.txt.gz';
filename IHC03 pipe 'gunzip -c ~/jim/data/Health/ihc03.txt.gz';
filename IHC04 pipe 'gunzip -c ~/jim/data/Health/ihc04.txt.gz';
filename IHC05 pipe 'gunzip -c ~/jim/data/Health/ihc05.txt.gz';
filename IHC06 pipe 'gunzip -c ~/jim/data/Health/ihc06.txt.gz';
filename IHC07 pipe 'gunzip -c ~/jim/data/Health/ihc07.txt.gz';
filename IHC08 pipe 'gunzip -c ~/jim/data/Health/ihc08.txt.gz';
filename IHC09 pipe 'gunzip -c ~/jim/data/Health/ihc09.txt.gz';
filename IHC10 pipe 'gunzip -c ~/jim/data/Health/ihc10.txt.gz';


%macro read_ihc(yr,dir);

options obs=max mprint;
data pub&yr;
infile &dir missover lrecl=2000;

if &yr=80 then do;
input q2 2 q3 3 NEWID 4-11 membnum 19-20 HMCPART 22 hmcpayer 26 MEDCAIDQ 30-31;
* delete obs for following year;
qyear=800+10*q2+q3;
drop q2 q3;
newid=9000000+newid;
end;

if 88<=&yr<=91 then do;
input qyear 1-3 NEWID 4-11 membnum 19-20 sscover 22 HMCPARTB 24 HMCPART 26 hmcpayer 30 MEDCAIDQ 32-33 OTHPLAN 74;
* delete obs for following year;
IF FLOOR(qyear/10) NE &yr THEN DELETE;
end;

if &yr=92 then do;
input qyear 1-3 NEWID 4-11 membnum 19-20 sscover 22 HMCPARTB 24 HMCPART 26 hmcpayer 30 MEDCAIDQ 32-33 OTHPLAN 62;
* delete obs for following year;
IF FLOOR(qyear/10) NE &yr THEN DELETE;
end;

if &yr=93 then do;
input qyear 1-3 NEWID 4-11 membnum 19-20 sscover 22 HMCPARTB 24 HMCPART 26 hmcpayer 30 MEDCAIDQ 32-33 OTHPLAN 62 
HHMCRENR 119 num_mcare 121-122 MDCDENR 169 num_mcaid 171-172;
* delete obs for following year;
IF FLOOR(qyear/10) NE &yr THEN DELETE;
end;

if 94<=&yr<=95 then do;
input qyear 1-3 NEWID 4-11 HHMCRENR 19 num_mcare 21-22 MDCDENR 69 num_mcaid 71-72 OTHPLAN 119;
* delete obs for following year for 94 only;
IF &yr=94 AND FLOOR(qyear/10) NE 94 THEN DELETE;
end;

if 96<=&yr<=110 then do;
input qyear 1-5 NEWID 6-13 HHMCRENR 21 num_mcare 23-24 MDCDENR 71 num_mcaid 73-74 OTHPLAN 121;
* DELETE OBS FOR FOLLOWING YEAR, BUT KEEP FOR 2004, B/C THAT'S A CHANGE-IN-SAMPLE YEAR,
  AND 2010 B/C IT'S THE FINAL YEAR OF DATA;
IF FLOOR(qyear/10) NE 1900+&yr AND &yr LE 103 THEN DELETE;
IF FLOOR(qyear/10) NE 1900+&yr AND &yr IN(105,106,107,108,109) THEN DELETE;
end;

*  Create count for 93:3 and before;
IF qyear LT 933 AND (HMCPARTB IN(1,2) OR  HMCPART IN(1,2)) THEN num_mcare=1;

count=1; 

*SAME variable, different name, so combine;
mcaid_cov=SUM(OF MEDCAIDQ num_mcaid);
*Variable name changes starting in 93:3;
IF qyear LT 933 THEN MDCDENR=hmcpayer;

IF othplan=1 THEN oth_hlth=1;
ELSE oth_hlth=0;

RUN; 
PROC MEANS;
RUN; 

PROC SORT;
   BY newid;
PROC MEANS SUM NOPRINT;
   BY newid;
   ID qyear MDCDENR HHMCRENR;
   VAR count mcaid_cov num_mcare oth_hlth;
   OUTPUT OUT=temp1 SUM=count mcaid_tot mcaresum oth_tot;
RUN;

DATA pub&yr; 
   SET temp1(KEEP=newid qyear count mcaid_tot mcaresum oth_tot MDCDENR HHMCRENR);
 
RUN;

%mend read_ihc;


%read_ihc(80,IHC8081);
%read_ihc(88,IHC88);
%read_ihc(89,IHC89);
%read_ihc(90,IHC90);
%read_ihc(91,IHC91);
%read_ihc(92,IHC92);
%read_ihc(93,IHC93);
%read_ihc(94,IHC94);
%read_ihc(95,IHC95);
%read_ihc(96,IHC96);
%read_ihc(97,IHC97);
%read_ihc(98,IHC98);
%read_ihc(99,IHC99);
%read_ihc(100,IHC00);
%read_ihc(101,IHC01);
%read_ihc(102,IHC02);
%read_ihc(103,IHC03);
%read_ihc(104,IHC04);
%read_ihc(105,IHC05);
%read_ihc(106,IHC06);
%read_ihc(107,IHC07);
%read_ihc(108,IHC08);
%read_ihc(109,IHC09);
%read_ihc(110,IHC10);


**********************************************************************
MAKE ADJUSTMENT FOR FACT THAT SOME OBS ARE IN BOTH 95:5 AND 96:1
THIS DELETES CU'S IN 1995 THAT ARE ALSO IN 1996
**********************************************************************;
DATA pub95; 
MERGE pub95(IN=in1) pub96(IN=in2); 
BY newid; 
if in2 THEN dat2=1; 
else dat2=0; 
IF in1; 
IF dat2=1 THEN DELETE; 
RUN; 
**********************************************************************
MAKE ADJUSTMENT FOR FACT THAT SOME OBS ARE IN BOTH 04:5 AND 05:1
THIS DELETES CU'S IN 2004 THAT ARE ALSO IN 2005
**********************************************************************;
DATA pub104; 
MERGE pub104(IN=in1) pub105(IN=in2); 
BY newid; 
if in2 THEN dat2=1; 
else dat2=0; 
IF in1; 
IF dat2=1 THEN DELETE; 
RUN; 


DATA all_pub;
SET pub80 pub88 pub89 pub90 pub91
    pub92 pub93 pub94 pub95 pub96 pub97 
    pub98 pub99 pub100 pub101 pub102 pub103 pub104 pub105
    pub106 pub107 pub108 pub109 pub110;

* THIS WILL MATCH SRV_YEAR FROM FAMILY FILES EVEN IN QUARTER 5
  OF A SURVEY YEAR B/C QYEAR HERE IS TAKEN FROM THE DATA, NOT 
  GENERATED BY ME;
IF 801 LE qyear LE 961 THEN srv_year=floor(qyear/10);
   ELSE IF qyear GE 19961 THEN srv_year=floor(qyear/10)-1900;

RUN;
PROC SORT;
BY newid srv_year;
RUN;


********************************************************************** 
COMBINE PUBLIC AND PRIVATE;
**********************************************************************; 
DATA mydat.all_health8010; 
MERGE 	all_priv(KEEP=newid srv_year qyear num_pol num_cov num_ind_plan num_fam_plan) 
	all_pub(KEEP=newid srv_year qyear mcaid_tot mcaresum oth_tot MDCDENR HHMCRENR);
BY newid srv_year;
RUN;

PROC SORT;
BY qyear newid;
PROC MEANS;
BY qyear;
RUN;

PROC SORT DATA=mydat.all_health8009;
BY qyear newid;
RUN;
proc compare base=mydat.all_health8010
             compare=mydat.all_health8009; 
   WHERE qyear LE 1094;
run;

